<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8"> 
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"> 
  <title>Redeem Code</title> 
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <link rel="stylesheet" href="/mbtech/layui.css"> 
  <link rel="stylesheet" href="/mbtech/common.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/css/layui.min.css">
  <style>
    body {
      background-image: url('/mbtech/bill_bg.png');
      background-size: cover;
      background-repeat: no-repeat;
    }
    .common_card {
      background: #fff;
      padding: 20px;
      margin: 20px;
      border-radius: 12px;
      box-shadow: 0 4px 8px rgba(0,0,0,0.05);
    }
    .bonus-header {
      font-family: Arial, sans-serif;
      font-size: 18px;
      font-weight: bold;
      color: #003862;
    }
    .bonus-desc {
      font-size: 14px;
      color: #666;
      margin-top: 10px;
    }
    .input-container {
      margin-top: 20px;
    }
    .layui-input {
      background: #f9f9f9;
      border-radius: 8px;
      font-size: 16px;
    }
    .layui-btn {
      width: 100%;
      border-radius: 8px;
      font-weight: bold;
      margin-top: 15px;
    }
    .msg {
      text-align: center;
      font-size: 14px;
      margin-top: 10px;
    }
    .msg.success { color: #28a745; }
    .msg.error { color: #f44336; }
  </style>
</head>

<body class="common_body">
  <div class="common_header common_header_order">
    <a href="javascript:history.back(-1)" class="back position">
      <p class="btn"><i class="layui-icon layui-icon-left layui-font-20"></i></p>
      Redeem Code
    </a>
  </div>

  <div class="common_card">
    <p class="bonus-header">🎁 Redeem Your Bonus</p>
    <p class="bonus-desc">Enter the bonus code to receive your reward.</p>

    <form class="layui-form input-container" id="redeem-form">
      <div class="layui-form-item">
        <input type="text" name="bonus_code" required placeholder="Enter your bonus code" class="layui-input">
      </div>
      <button class="layui-btn layui-btn-normal" lay-submit lay-filter="submitBonus">Redeem Now</button>
    </form>

    <div class="msg" id="messageBox"></div>
  </div>

  <script src="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/layui.min.js"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    layui.use(['form', 'layer'], function(){
      var form = layui.form;
      var layer = layui.layer;

      form.on('submit(submitBonus)', function(data){
        layer.load(1, {shade: [0.1,'#fff']});
        $('#messageBox').text('');

        $.ajax({
          url: "{{ route('user.submit-bonus') }}",
          method: "POST",
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          data: data.field,
          success: function(res){
            layer.closeAll('loading');
            if(res.status === 1){
              $('#messageBox').text(res.message).addClass('msg success').removeClass('error');
              layer.msg(res.message, {icon: 1});
            } else {
              $('#messageBox').text(res.message).addClass('msg error').removeClass('success');
              layer.msg(res.message, {icon: 2});
            }
          },
          error: function(){
            layer.closeAll('loading');
            $('#messageBox').text("An error occurred.").addClass('msg error');
          }
        });

        return false;
      });
    });
  </script>
</body>
</html>
